<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://schemas.microsoft.com/winfx/2006/xaml/presentation">
<xsl:output method="xml" indent="no"/>
<xsl:output omit-xml-declaration="yes"/>

<xsl:variable name="FontFamily" select="'Arial'"/>
<xsl:variable name="DefaultFontSize" select="'14'"/>

<xsl:template match="/">
	<xsl:element name="Flow">
		<xsl:element name="Section">
			<xsl:element name="Section">
				<xsl:apply-templates select="PROJECT/LAYOUT/ARTICLE/COMPONENT"/>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<!-- Removes all escape charecter from node text -->
<xsl:template name="RemoveEscapes" match="RICHTEXT">
	<xsl:call-template name="RemoveAllEscapes">
		<xsl:with-param name="text" select="."/>
	</xsl:call-template>
</xsl:template>

<!-- Removes all escape charecter from passed text -->
<xsl:template name="RemoveAllEscapes">
	<xsl:param name="text"/>

	<!-- Replace softRetrun with '&#x0007;' -->
	<xsl:variable name="withoutSoftRetrun">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$text" />
		<xsl:with-param name="replace" select="'&amp;softReturn;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace hardRetrun with '&#x000D;' -->
	<xsl:variable name="withoutHardRetrun">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutSoftRetrun" />
		<xsl:with-param name="replace" select="'&amp;hardReturn;'" />
		<xsl:with-param name="by" select="'&#x000D;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace mdash with '&#x2014;' -->
	<xsl:variable name="withoutMdash">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutHardRetrun" />
		<xsl:with-param name="replace" select="'&amp;mdash;'" />
		<xsl:with-param name="by" select="'&#x2014;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace ndash with '&#x2013;' -->
	<xsl:variable name="withoutNdash">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutMdash" />
		<xsl:with-param name="replace" select="'&amp;ndash;'" />
		<xsl:with-param name="by" select="'&#x2013;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace nbsp with '&#x00A0;' -->
	<xsl:variable name="withoutNbsp">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutNdash" />
		<xsl:with-param name="replace" select="'&amp;nbsp;'" />
		<xsl:with-param name="by" select="'&#x00A0;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace ensp with '&#x2002;' -->
	<xsl:variable name="withoutEnsp">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutNbsp" />
		<xsl:with-param name="replace" select="'&amp;ensp;'" />
		<xsl:with-param name="by" select="'&#x2002;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace emsp with '&#x2003;' -->
	<xsl:variable name="withoutEmsp">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEnsp" />
		<xsl:with-param name="replace" select="'&amp;emsp;'" />
		<xsl:with-param name="by" select="'&#x2003;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace lineFeed with '&#x000A;' -->
	<xsl:variable name="withoutLineFeed">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEmsp" />
		<xsl:with-param name="replace" select="'&amp;nbsp;'" />
		<xsl:with-param name="by" select="'&#x000A;'" />
	</xsl:call-template>
	</xsl:variable>	

	<!-- Replace Hyphen with '&#x2010;' -->
	<xsl:variable name="withoutHyphen">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutLineFeed" />
		<xsl:with-param name="replace" select="'&amp;hyphen;'" />
		<xsl:with-param name="by" select="'&#x2010;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace hTab with '&#x0009;' -->
	<xsl:variable name="withoutHtab">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutHyphen" />
		<xsl:with-param name="replace" select="'&amp;hTab;'" />
		<xsl:with-param name="by" select="'&#x0009;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace punctSpace with '&#x2008;' -->
	<xsl:variable name="withoutPunctSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutHtab" />
		<xsl:with-param name="replace" select="'&amp;punctSpace;'" />
		<xsl:with-param name="by" select="'&#x2008;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace etx with '&#x0003;' -->
	<xsl:variable name="withoutEtx">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutPunctSpace" />
		<xsl:with-param name="replace" select="'&amp;etx;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace eot with '&#x0004;' -->
	<xsl:variable name="withoutEot">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEtx" />
		<xsl:with-param name="replace" select="'&amp;eot;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace enq with '&#x0005;' -->
	<xsl:variable name="withoutEnq">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEot" />
		<xsl:with-param name="replace" select="'&amp;enq;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace ack with '&#x0006;' -->
	<xsl:variable name="withoutAck">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEnq" />
		<xsl:with-param name="replace" select="'&amp;ack;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace bs with '&#x0008;' -->
	<xsl:variable name="withoutBs">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutAck" />
		<xsl:with-param name="replace" select="'&amp;bs;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace vTab with '&#x000B;' -->
	<xsl:variable name="withoutVtab">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutBs" />
		<xsl:with-param name="replace" select="'&amp;vTab;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace boxBreak with '&#x000C;' -->
	<xsl:variable name="withoutBoxBreak">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutVtab" />
		<xsl:with-param name="replace" select="'&amp;boxBreak;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace so with '&#x000E;' -->
	<xsl:variable name="withoutSo">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutBoxBreak" />
		<xsl:with-param name="replace" select="'&amp;so;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace flexSpace with '&#x000F;' -->
	<xsl:variable name="withoutFlexSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutSo" />
		<xsl:with-param name="replace" select="'&amp;flexSpace;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace dle with '&#x0010;' -->
	<xsl:variable name="withoutDle">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutFlexSpace" />
		<xsl:with-param name="replace" select="'&amp;dle;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace dcOne with '&#x0011;' -->
	<xsl:variable name="withoutDcOne">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDle" />
		<xsl:with-param name="replace" select="'&amp;dcOne;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace dcTwo with '&#x0012;' -->
	<xsl:variable name="withoutDcTwo">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDcOne" />
		<xsl:with-param name="replace" select="'&amp;dcTwo;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace dcThree with '&#x0013;' -->
	<xsl:variable name="withoutDcThree">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDcTwo" />
		<xsl:with-param name="replace" select="'&amp;dcThree;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace dcFour with '&#x0014;' -->
	<xsl:variable name="withoutDcFour">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDcThree" />
		<xsl:with-param name="replace" select="'&amp;dcFour;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace nak with '&#x0015;' -->
	<xsl:variable name="withoutNak">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDcFour" />
		<xsl:with-param name="replace" select="'&amp;nak;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace syn with '&#x0016;' -->
	<xsl:variable name="withoutSyn">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutNak" />
		<xsl:with-param name="replace" select="'&amp;syn;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace etb with '&#x0017;' -->
	<xsl:variable name="withoutEtb">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutSyn" />
		<xsl:with-param name="replace" select="'&amp;etb;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace can with '&#x0018;' -->
	<xsl:variable name="withoutCan">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEtb" />
		<xsl:with-param name="replace" select="'&amp;can;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace em with '&#x0019;' -->
	<xsl:variable name="withoutEm">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutCan" />
		<xsl:with-param name="replace" select="'&amp;em;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace sub with '&#x001A;' -->
	<xsl:variable name="withoutSub">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEm" />
		<xsl:with-param name="replace" select="'&amp;sub;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>
	
	<!-- Replace esc with '&#x001B;' -->
	<xsl:variable name="withoutEsc">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutSub" />
		<xsl:with-param name="replace" select="'&amp;esc;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace fs with '&#x001C;' -->
	<xsl:variable name="withoutFs">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutEsc" />
		<xsl:with-param name="replace" select="'&amp;fs;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>
	
	<!-- Replace discReturn with '&#x001D;' -->
	<xsl:variable name="withoutDiscReturn">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutFs" />
		<xsl:with-param name="replace" select="'&amp;discReturn;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace indentHere with '&#x001E;' -->
	<xsl:variable name="withoutIndentHere">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutDiscReturn" />
		<xsl:with-param name="replace" select="'&amp;indentHere;'" />
		<xsl:with-param name="by" select="'    '" />
	</xsl:call-template>
	</xsl:variable>
	
	<!-- Replace shy with '&#x001F;' -->
	<xsl:variable name="withoutShy">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutIndentHere" />
		<xsl:with-param name="replace" select="'&amp;shy;'" />
		<xsl:with-param name="by" select="' '" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace threePerEmSpace with '&#x2004;' -->
	<xsl:variable name="withoutThreePerEmSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutShy" />
		<xsl:with-param name="replace" select="'&amp;threePerEmSpace;'" />
		<xsl:with-param name="by" select="'&#x2004;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace fourPerEmSpace with '&#x2005;' -->
	<xsl:variable name="withoutFourPerEmSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutThreePerEmSpace" />
		<xsl:with-param name="replace" select="'&amp;fourPerEmSpace;'" />
		<xsl:with-param name="by" select="'&#x2005;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace sixPerEmSpace with '&#x2006;' -->
	<xsl:variable name="withoutSixPerEmSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutFourPerEmSpace" />
		<xsl:with-param name="replace" select="'&amp;sixPerEmSpace;'" />
		<xsl:with-param name="by" select="'&#x2006;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace figureSpace with '&#x2007;' -->
	<xsl:variable name="withoutFigureSpaceSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutSixPerEmSpace" />
		<xsl:with-param name="replace" select="'&amp;figureSpace;'" />
		<xsl:with-param name="by" select="'&#x2007;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace thinsp with '&#x2009;' -->
	<xsl:variable name="withoutThinsp">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutFigureSpaceSpace" />
		<xsl:with-param name="replace" select="'&amp;thinsp;'" />
		<xsl:with-param name="by" select="'&#x2009;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace hairSpace with '&#x200A;' -->
	<xsl:variable name="withoutHairSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutThinsp" />
		<xsl:with-param name="replace" select="'&amp;hairSpace;'" />
		<xsl:with-param name="by" select="'&#x200A;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace zeroWidthSpace with '&#x200B;' -->
	<xsl:variable name="withoutZeroWidthSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutHairSpace" />
		<xsl:with-param name="replace" select="'&amp;zeroWidthSpace;'" />
		<xsl:with-param name="by" select="'&#x200B;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace wordJoiner with '&#x2060;' -->
	<xsl:variable name="withoutWordJoiner">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutZeroWidthSpace" />
		<xsl:with-param name="replace" select="'&amp;wordJoiner;'" />
		<xsl:with-param name="by" select="'&#x2060;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace ideographicSpace with '&#x3000;' -->
	<xsl:variable name="withoutIdeographicSpace">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutWordJoiner" />
		<xsl:with-param name="replace" select="'&amp;ideographicSpace;'" />
		<xsl:with-param name="by" select="'&#x3000;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Replace discHyphen with '&#x00AD;' -->
	<xsl:variable name="withoutDiscHyphen">
	<xsl:call-template name="replace-text">
		<xsl:with-param name="text" select="$withoutIdeographicSpace" />
		<xsl:with-param name="replace" select="'&amp;discHyphen;'" />
		<xsl:with-param name="by" select="'&#x00AD;'" />
	</xsl:call-template>
	</xsl:variable>

	<!-- Write the final modified text -->
	<xsl:value-of select="$withoutDiscHyphen"/>

</xsl:template>

<!-- Search specified text and replaces text with passed text -->
<xsl:template name="replace-text">
	<xsl:param name="text"/>
	<xsl:param name="replace" />
	<xsl:param name="by"  />

	<xsl:choose>
		<xsl:when test="contains($text, $replace)">
			<xsl:variable name="substringBefore" select="substring-before($text, $replace)"/>

			<xsl:choose>
				<xsl:when test="$substringBefore != $replace">
					<xsl:value-of select="$substringBefore"/>
					<xsl:value-of select="$by" disable-output-escaping="no"/>
					<xsl:call-template name="replace-text">
						<xsl:with-param name="text" select="substring-after($text, $replace)"/>
						<xsl:with-param name="replace" select="$replace" />
						<xsl:with-param name="by" select="$by" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$by" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Component template iterates all components and pass component boxuid to Spread template -->
<xsl:template name="Component" match="COMPONENT">
	<xsl:apply-templates select="../../SPREAD">
		<xsl:with-param name="compBoxUID" select="@BOXUID"/>
		<xsl:with-param name="fontFamily" select="$FontFamily"/>
		<xsl:with-param name="fontSize" select="$DefaultFontSize" />
		<xsl:with-param name="textIndent" select="0" />
		<xsl:with-param name="textAlignment" select="'Left'" />
	</xsl:apply-templates>	
</xsl:template>

<!-- Spread template iterates all Boxes and call Box template -->
<xsl:template name="Spread" match="SPREAD">
	<xsl:param name="compBoxUID" select="'$compBoxUID'" />
	<xsl:param name="fontFamily" select="$FontFamily"/>
	<xsl:param name="fontSize" select="$fontSize" />
	<xsl:param name="textIndent" select="$textIndent" />
	<xsl:param name="textAlignment" select="$textAlignment" />

	<xsl:if test="BOX/ID/@UID = $compBoxUID">
		<xsl:apply-templates select="BOX">
			<xsl:with-param name="compBoxUID" select="$compBoxUID"/>
			<xsl:with-param name="fontFamily" select="$FontFamily"/>
			<xsl:with-param name="fontSize" select="$fontSize" />
			<xsl:with-param name="textIndent" select="$textIndent" />
			<xsl:with-param name="textAlignment" select="$textAlignment" />
			<xsl:with-param name="anchBox" select="'false'" />
		</xsl:apply-templates>
	</xsl:if>
</xsl:template>

<!-- Box template iterates all Boxes and call Picture/Paragraph template -->
<xsl:template name="Box" match="BOX | GROUP | TABLE">
	<xsl:param name="compBoxUID" select="'$compBoxUID'" />
	<xsl:param name="fontFamily" select="$FontFamily"/>
	<xsl:param name="fontSize" select="$fontSize" />
	<xsl:param name="textIndent" select="$textIndent" />
	<xsl:param name="textAlignment" select="$textAlignment" />
	<xsl:param name="anchBox" select="$anchBox" />

	<xsl:if test="ID/@UID = $compBoxUID">
		<xsl:if test="TEXT">
			<xsl:apply-templates select="TEXT/STORY/PARAGRAPH | TEXT/STORY/OVERMATTER/PARAGRAPH">
				<xsl:with-param name="pageID" select="GEOMETRY/@PAGE - 1"/>
				<xsl:with-param name="fontFamily" select="$FontFamily"/>
				<xsl:with-param name="fontSize" select="$fontSize" />
				<xsl:with-param name="textIndent" select="$textIndent" />
				<xsl:with-param name="textAlignment" select="$textAlignment" />
				<xsl:with-param name="anchBox" select="$anchBox" />
			</xsl:apply-templates>
		</xsl:if>

		<xsl:if test="PICTURE">
			<xsl:variable name="Top" select="./GEOMETRY/POSITION/TOP"/>
			<xsl:variable name="Bottom" select="./GEOMETRY/POSITION/BOTTOM"/>
			<xsl:variable name="Right" select="./GEOMETRY/POSITION/RIGHT"/>
			<xsl:variable name="Left" select="./GEOMETRY/POSITION/LEFT"/>

			<xsl:if test="CONTENT != ''">
				<xsl:apply-templates select="PICTURE">
					<xsl:with-param name="imageSource" select="$compBoxUID"/>
					<xsl:with-param name="imageWidth" select="$Right - $Left" />
					<xsl:with-param name="imageHeight" select="$Bottom - $Top" />
					<xsl:with-param name="anchBox" select="$anchBox" />
				</xsl:apply-templates>
			</xsl:if> 
		</xsl:if>  
		<xsl:if test="local-name() = 'GROUP' or local-name() = 'TABLE' or @BOXTYPE='CT_NONE'">
			<xsl:variable name="Top" select="./GEOMETRY/POSITION/TOP"/>
			<xsl:variable name="Bottom" select="./GEOMETRY/POSITION/BOTTOM"/>
			<xsl:variable name="Right" select="./GEOMETRY/POSITION/RIGHT"/>
			<xsl:variable name="Left" select="./GEOMETRY/POSITION/LEFT"/>
			<xsl:element name="Image">
				<xsl:attribute name="Source">
					<xsl:choose>
						<xsl:when test="../@EXPORTREFLOWPICAS = 'JPEG'">
							<xsl:value-of select="concat('images/', $compBoxUID, '.jpg')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('images/', $compBoxUID, '.png')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="Width"><xsl:value-of select="$Right - $Left"/></xsl:attribute>
				<xsl:attribute name="Height"><xsl:value-of select="$Bottom - $Top"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:if>  
</xsl:template>

<!-- Added info related to picture component -->
<xsl:template name="PictureComponent" match="PICTURE">
	<xsl:param name="imageSource" select="$imageSource" />
	<xsl:param name="imageWidth" select="$imageWidth" />
	<xsl:param name="imageHeight" select="$imageHeight" />
	<xsl:param name="anchBox" select="$anchBox" />

	<xsl:choose>
		<xsl:when test="$anchBox = 'false'">
			<xsl:element name="Paragraph">
				<xsl:attribute name="TextAlignment">
					<xsl:value-of select="'Center'" />
				</xsl:attribute>
				<xsl:call-template name="Picture">
					<xsl:with-param name="imageSource" select="$imageSource" />
					<xsl:with-param name="imageWidth" select="$imageWidth" />
					<xsl:with-param name="imageHeight" select="$imageHeight" />
				</xsl:call-template>
			</xsl:element>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="Picture">
				<xsl:with-param name="imageSource" select="$imageSource" />
				<xsl:with-param name="imageWidth" select="$imageWidth" />
				<xsl:with-param name="imageHeight" select="$imageHeight" />
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Added info related to picture component -->
<xsl:template name="Picture">
	<xsl:param name="imageSource" select="$imageSource" />
	<xsl:param name="imageWidth" select="$imageWidth" />
	<xsl:param name="imageHeight" select="$imageHeight" />

	<xsl:element name="Image">
		<xsl:attribute name="Source">
			<xsl:choose>
				<xsl:when test="../@EXPORTREFLOWPICAS = 'JPEG'">
					<xsl:value-of select="concat('images/', $imageSource, '.jpg')" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('images/', $imageSource, '.png')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>

		<xsl:attribute name="Width">
			<xsl:value-of select="$imageWidth" />
		</xsl:attribute>

		<xsl:attribute name="Height">
			<xsl:value-of select="$imageHeight" />
		</xsl:attribute>
	</xsl:element>
</xsl:template>

<!-- Parse picture filepath and extract file name only -->
<xsl:template name="ParseImageFileName">
	<xsl:param name="imagePath" select="$imagePath" />

	<xsl:choose>
		<xsl:when test="contains($imagePath, '/')">
			<xsl:call-template name="ParseImageFileName">
				<xsl:with-param name="imagePath" select="substring-after($imagePath, '/')" />
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="contains($imagePath, '\')">
					<xsl:call-template name="ParseImageFileName">
						<xsl:with-param name="imagePath" select="substring-after($imagePath, '\')" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="contains($imagePath, ':')">
							<xsl:call-template name="ParseImageFileName">
							<xsl:with-param name="imagePath" select="substring-after($imagePath, ':')" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="contains($imagePath, '.')">
								<xsl:value-of select="substring-before($imagePath, '.')" />
							</xsl:if>
							<xsl:value-of select="'.jpg'" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Added info related to text component -->
<xsl:template name="TextComponent" match="PARAGRAPH">
	<xsl:param name="pageID" select="$pageID" />
	<xsl:param name="fontFamily" select="$FontFamily"/>
	<xsl:param name="fontSize" select="$fontSize" />
	<xsl:param name="textIndent" select="$textIndent" />
	<xsl:param name="textAlignment" select="$textAlignment" />
	<xsl:param name="anchBox" select="$anchBox" />

	<xsl:choose>
		<xsl:when test="$anchBox = 'false'">
			<xsl:element name="Paragraph">
				<xsl:call-template name="Paragraph">
					<xsl:with-param name="pageID" select="$pageID"/>
					<xsl:with-param name="fontFamily" select="$FontFamily"/>
					<xsl:with-param name="fontSize" select="$fontSize" />
					<xsl:with-param name="textIndent" select="$textIndent" />
					<xsl:with-param name="textAlignment" select="$textAlignment" />
				</xsl:call-template>
			</xsl:element>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="Paragraph">
				<xsl:with-param name="pageID" select="$pageID"/>
				<xsl:with-param name="fontFamily" select="$FontFamily"/>
				<xsl:with-param name="fontSize" select="$fontSize" />
				<xsl:with-param name="textIndent" select="$textIndent" />
				<xsl:with-param name="textAlignment" select="$textAlignment" />
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Added info related to text component -->
<xsl:template name="Paragraph">
	<xsl:param name="pageID" select="'$pageID'" />
	<xsl:param name="fontFamily" select="$FontFamily"/>
	<xsl:param name="fontSize" select="$fontSize" />
	<xsl:param name="textIndent" select="$textIndent" />
	<xsl:param name="textAlignment" select="$textAlignment" />
	<xsl:if test="not(FORMAT/BNSTYLE/@NAME='None')">
		<xsl:attribute name="TextIndent">	
			<xsl:if test="string-length(FORMAT/BNSTYLE/@BNCHAR)='1'">
				<xsl:value-of select="'-18'"/>
			</xsl:if>
			<xsl:if test="string-length(FORMAT/BNSTYLE/@BNCHAR) > '1'">
				<xsl:value-of select="-20 - 3*string-length(FORMAT/BNSTYLE/@BNCHAR)"/>
			</xsl:if>
		</xsl:attribute>
	</xsl:if>
	<xsl:attribute name="Margin">
		<xsl:if test="@INDENTLEVEL">
			<xsl:value-of select="@INDENTLEVEL * 30"/>
		</xsl:if>
		<xsl:if test="not(@INDENTLEVEL)">
			<xsl:choose>
				<xsl:when test="FORMAT/@LEFTINDENT">
						<xsl:value-of select="FORMAT/@LEFTINDENT" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'30'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>		
		<xsl:value-of select="', 5 ,'"/>
		<xsl:choose>
			<xsl:when test="FORMAT/@RIGHTINDENT">
					<xsl:value-of select="FORMAT/@RIGHTINDENT" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'0'"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="', 5'"/>
	</xsl:attribute>

	<xsl:attribute name="TextAlignment">
		<xsl:choose>
			<xsl:when test="FORMAT/@ALIGNMENT">
				<xsl:if test="'LEFT' = FORMAT/@ALIGNMENT">
					<xsl:value-of select="'Left'" />
				</xsl:if>
				<xsl:if test="'CENTERED' = FORMAT/@ALIGNMENT">
					<xsl:value-of select="'Center'" />
				</xsl:if>
				<xsl:if test="'JUSTIFIED' = FORMAT/@ALIGNMENT">
					<xsl:value-of select="'Justify'" />
				</xsl:if>
				<xsl:if test="'RIGHT' = FORMAT/@ALIGNMENT">
					<xsl:value-of select="'Right'" />
				</xsl:if>
				<xsl:if test="'FORCED' = FORMAT/@ALIGNMENT">
					<xsl:value-of select="'Forced'" />
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$textAlignment" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>

	<xsl:attribute name="FontFamily">
		<xsl:value-of select="$FontFamily" />
	</xsl:attribute>

	<xsl:attribute name="FontSize">
		<xsl:value-of select="$fontSize" />
	</xsl:attribute>

	<xsl:for-each select="*">
		<xsl:if test="local-name() = 'RICHTEXT'">
			<xsl:if test="@HYPERLINKREF and @HLTYPE='WWWURL'">
				<xsl:element name="Hyperlink">
					<xsl:attribute name="NavigateUri">
						<xsl:value-of select="@HYPERLINKREF"/>
					</xsl:attribute>
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
			<xsl:if test="not(@HYPERLINKREF)">
				<xsl:call-template name="RICHTEXT">
					<xsl:with-param name="pageID" select="$pageID"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<xsl:if test="local-name() = 'RUBI'">
			<xsl:for-each select="*">
				<xsl:if test="local-name() = 'RICHTEXT'">
					<xsl:call-template name="RICHTEXT">
						<xsl:with-param name="pageID" select="$pageID"/>
					</xsl:call-template>
					<xsl:element name="Run">
						<xsl:value-of select="'('"/>
						<xsl:value-of select="../RUBITEXT/RICHTEXT"/>
						<xsl:value-of select="')'"/>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="local-name() = 'FORMAT'">
			<xsl:call-template name="FORMAT">
				<xsl:with-param name="pageID" select="$pageID"/>
			</xsl:call-template>	
		</xsl:if>
		<xsl:if test="local-name() = 'ANCHOREDBOXREF'">
			<xsl:variable name="anchCompBoxUID" select="@BOXUID"/>

			<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
				<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
				<xsl:with-param name="fontFamily" select="$FontFamily"/>
				<xsl:with-param name="fontSize" select="$fontSize" />
				<xsl:with-param name="textIndent" select="$textIndent" />
				<xsl:with-param name="textAlignment" select="$textAlignment" />
				<xsl:with-param name="anchBox" select="'true'" />
			</xsl:apply-templates>
		</xsl:if>
    <xsl:if test="local-name() = 'CALLOUTANCHOR'">
      <xsl:variable name="anchCompBoxUID" select="./CALLOUTBOXREF/@UID"/>
      <xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
        <xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
        <xsl:with-param name="fontFamily" select="$FontFamily"/>
        <xsl:with-param name="fontSize" select="$fontSize"/>
        <xsl:with-param name="textIndent" select="$textIndent"/>
        <xsl:with-param name="textAlignment" select="$textAlignment"/>
        <xsl:with-param name="anchBox" select="'true'"/>
      </xsl:apply-templates>
    </xsl:if>
	  <xsl:if test="position()=last() and not(../following-sibling::PARAGRAPH)">
			<xsl:if test="../../OVERMATTER">
				<xsl:for-each select="../../OVERMATTER/*">
					<xsl:if test="local-name() = 'RICHTEXT'">
						<xsl:call-template name="RICHTEXT">
							<xsl:with-param name="pageID" select="$pageID"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="local-name() = 'ANCHOREDBOXREF'">
						<xsl:variable name="anchCompBoxUID" select="@BOXUID"/>
			
						<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
							<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
							<xsl:with-param name="fontFamily" select="$FontFamily"/>
							<xsl:with-param name="fontSize" select="$fontSize" />
							<xsl:with-param name="textIndent" select="$textIndent" />
							<xsl:with-param name="textAlignment" select="$textAlignment" />
							<xsl:with-param name="anchBox" select="'true'" />
						</xsl:apply-templates>
					</xsl:if>
          <xsl:if test="local-name() = 'CALLOUTANCHOR'">
           <xsl:variable name="anchCompBoxUID" select="./CALLOUTBOXREF/@UID"/>
            <xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
              <xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
              <xsl:with-param name="fontFamily" select="$FontFamily"/>
              <xsl:with-param name="fontSize" select="$fontSize"/>
              <xsl:with-param name="textIndent" select="$textIndent"/>
              <xsl:with-param name="textAlignment" select="$textAlignment"/>
              <xsl:with-param name="anchBox" select="'true'"/>
            </xsl:apply-templates>
          </xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:if>
	</xsl:for-each>

</xsl:template>
<!-- Add FORMAT tag related to text component -->
<xsl:template name="FORMAT" match="FORMAT">
	<xsl:param name="pageID" select="'$pageID'" />
	<xsl:if test="not(BNSTYLE/@NAME='None')">
		<xsl:element name="Run">
			<xsl:attribute name="Tag">
				<xsl:number format="__" value="$pageID" />
			</xsl:attribute>
			<xsl:attribute name="xml:space">
				<xsl:value-of select="'preserve'"/>
			</xsl:attribute>
			<xsl:value-of select="BNSTYLE/@BNCHAR"/>
			<xsl:value-of select="'   '"/>
		</xsl:element>
	</xsl:if>
</xsl:template>
	
<!-- Add RUN tag related to text component -->
<xsl:template name="RICHTEXT" match="RICHTEXT">
	<xsl:param name="pageID" select="'$pageID'" />

	<xsl:element name="Run">
		<xsl:if test="@BOLD">
			<xsl:attribute name="FontWeight">
				<xsl:value-of select="'Bold'" />
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="@ITALIC">
			<xsl:attribute name="FontStyle">
				<xsl:value-of select="'Italic'" />
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="@SIZE">
			<xsl:attribute name="FontSize">
				<xsl:value-of select="@SIZE" />
			</xsl:attribute>
		</xsl:if>

		<xsl:attribute name="Tag">
			<xsl:number format="__" value="$pageID" />
		</xsl:attribute>

		<xsl:if test="@STRIKETHRU='true' or @UNDERLINE='true'">
			<xsl:variable name="underLine" select="'Underline'"/>
			<xsl:variable name="strikeThrough" select="'Strikethrough'"/>

			<xsl:attribute name="TextDecorations">
				<xsl:choose>
					<xsl:when test="@STRIKETHRU='true' and @UNDERLINE='true'">
						<xsl:value-of select="concat($underLine, ', ' ,$strikeThrough)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="@STRIKETHRU='true'">
							<xsl:value-of select="$strikeThrough" />
						</xsl:if>
						<xsl:if test="@UNDERLINE='true'">
							<xsl:value-of select="$underLine" />
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="@SUPERSCRIPT">
			<xsl:attribute name="Typography.Variants">
				<xsl:value-of select="'Superscript'" />
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="@SUPERIOR">
			<xsl:attribute name="Typography.Variants">
				<xsl:value-of select="'Superscript'" />
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="@SUBSCRIPT">
			<xsl:attribute name="Typography.Variants">
				<xsl:value-of select="'Subscript'" />
			</xsl:attribute>
		</xsl:if>

		<!--xsl:value-of select="." /-->
		<xsl:call-template name="RemoveEscapes" />
	</xsl:element>
</xsl:template>

</xsl:stylesheet>
